<?php
require_once('../../config.php');
require_once($CFG->dirroot . '/repository/lib.php');
require_login();
global $DB, $USER, $OUTPUT, $PAGE;

$title = 'My Tracks';
$pagetitle = $title;
$PAGE->set_context(context_system::instance());
$PAGE->set_url($CFG->wwwroot.'/local/public/view-courses.php');
$PAGE->set_title($title);
$PAGE->set_heading($title);
$PAGE->set_pagelayout('standard');
$PAGE->requires->css('/local/public/css/view-courses.css');
$PAGE->requires->css('/local/public/css/bootstrap.min.css');
$PAGE->requires->css('/local/public/css/font-awesome.min.css');
$PAGE->requires->js('/local/public/amd/src/view-courses.js');

// $parent = $DB->get_record_sql("SELECT * FROM {course_categories}");

$data = $DB->get_records_sql("SELECT mc.* FROM {course} mc  where mc.id != 1");

$instructor_roleid = $DB->get_field('role','id',['shortname'=>'manager']);
$admin = get_admin();

if (!is_siteadmin()) {   // if user is other than site admin
   if (!user_has_role_assignment($USER->id,$instructor_roleid)) {
      throw new moodle_exception('you dont have permission to access this page', 'core');

   }
   else {
     
      $trackname = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE (usercreated = $USER->id OR usercreated = $admin->id OR id IN (SELECT parent FROM {course_categories} WHERE visible = 1)) AND parent=0  ORDER BY id DESC");
   }
}
// if user is site admin
else {
   $trackname = $DB->get_records('course_categories', ['parent'=> 0],'id desc', $fields='*', $limitfrom=0, $limitnum=0);
}

echo $OUTPUT->header();

function get_course_image($courseid)
{
   global $COURSE;
   $url = '';

   $context = context_course::instance($courseid);
   $fs = get_file_storage();
   $files = $fs->get_area_files($context->id, 'course', 'overviewfiles', 0);

   foreach ($files as $f) {
      if ($f->is_valid_image()) {
         $url = moodle_url::make_pluginfile_url($f->get_contextid(), $f->get_component(), $f->get_filearea(), null, $f->get_filepath(), $f->get_filename(), false);
      }
   }

   return $url;
}

foreach ($trackname as $datavalue) {
   $edit_permission = false;
// for edit and delete permission
if ($DB->record_exists('course_categories',['id'=>$datavalue->id,'usercreated'=>$USER->id])) {
   $edit_permission = true;
}


if (is_siteadmin()) { // if user is siteadmin
   if (!$DB->record_exists('course_categories',['id'=>$datavalue->id,'usercreated'=>$USER->id])) { // if track is not created by admin
      
      if (!$DB->record_exists('course_categories',['parent'=>$datavalue->id,'visible'=>1] )) {
         if (!$DB->record_exists_sql("SELECT * FROM {request_subcategory} WHERE subcategory_id IN (SELECT id FROM {course_categories} WHERE parent=$datavalue->id)")) {
         continue;
       }
      }
   $sub_courses = $DB->get_records_sql("SELECT cc.* FROM {course_categories} cc  LEFT JOIN {request_subcategory} rs ON rs.subcategory_id = cc.id WHERE cc.parent =  $datavalue->id");
}
else {
   # code...
   $sub_courses = $DB->get_records('course_categories', ['parent' => $datavalue->id]);
}
}

else {   // if user is teacher
   // $sub_courses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent = $datavalue->id AND (usercreated = $USER->id OR usercreated = $admin->id)");

   if (!$DB->record_exists('course_categories',['id'=>$datavalue->id,'usercreated'=>$USER->id])) {
      $sub_courses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent = $datavalue->id AND visible = 1");
      if ($DB->record_exists_sql("SELECT cc.* FROM {course_categories} cc WHERE cc.parent = $datavalue->id AND cc.visible = 1")) {
        
      }
      else {
         continue;
      }
   }
   else {
  $sub_courses = $DB->get_records_sql("SELECT * FROM {course_categories} WHERE parent = $datavalue->id AND (usercreated = $USER->id OR usercreated = $admin->id)");
   }

}
   $context = context_coursecat::instance($datavalue->id);
   $test = file_rewrite_pluginfile_urls($datavalue->description, 'pluginfile.php', $context->id, 'coursecat', 'description', null);
   
  
  if ($test) {
   $test = $test;
      
   } else {
   $test = '<img class="card-img-top" src="image/courses.jpg" alt="Card image">';

   }   

   $track_name[]=['trackname'=>$datavalue->name,'trackimage'=>$test,'subcoursecount'=>count($sub_courses),'starttext'=>substr($datavalue->text,0,50),'endtext'=>substr($datavalue->text,50,strlen($datavalue->text)),'trackid'=>$datavalue->id,'edit_permission'=>$edit_permission];

}

$data = [
  'trackname'=>$track_name

];

echo $OUTPUT->render_from_template('local_public/track', $data);
 echo $OUTPUT->footer();

?>

