<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The columns layout for the classic theme.
 *
 * @package   theme_classic
 * @copyright 2018 Bas Brands
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();
global $DB, $USER, $color;

$bodyattributes = $OUTPUT->body_attributes();
$blockspre = $OUTPUT->blocks('side-pre');
$blockspost = $OUTPUT->blocks('side-post');

$hassidepre = $PAGE->blocks->region_has_content('side-pre', $OUTPUT);
$hassidepost = $PAGE->blocks->region_has_content('side-post', $OUTPUT);
$PAGE->set_secondary_navigation(false);
$renderer = $PAGE->get_renderer('core');
$header = $PAGE->activityheader;
$headercontent = $header->export_for_template($renderer);

// get storage
$free_space = disk_free_space("/");
$total_space = disk_total_space("/");
if (is_numeric($total_space) && is_numeric($free_space)) {
  $filled_storage = formatBytes($total_space - $free_space);
} 
// if (is_numeric($filled_storage) && is_numeric($total_space)) {
  $usage_percent = ($filled_storage/formatBytes($total_space))*100;
  $usage_percent = sprintf("%0.2f", $usage_percent);
// } 

// get memory
$system_info = getSystemMemInfo();
$total_memory = $system_info['MemTotal'];
$total_mem = sprintf("%0.2f",strtok($total_memory, " ")/(1024*1024));

$mem_free = $system_info['MemAvailable'];
$memory_free = sprintf("%0.2f",strtok($mem_free, " ")/(1024*1024));
$used_mem = $total_mem - $memory_free;
$mem_percent = sprintf("%0.2f",($used_mem/$total_mem) *100);

// get cpu usage

$exec_loads = sys_getloadavg();
$exec_cores = trim(shell_exec("grep -P '^processor' /proc/cpuinfo|wc -l"));

// if (is_numeric($exec_loads[1]) && is_numeric($exec_cores) && $exec_cores > 0) {
  $cpu_percent = round($exec_loads[1]/($exec_cores + 1)*100, 0) . '%';
// }

// if (is_numeric($exec_cores)) {

  $cpu_total_cores  = $exec_cores + 1;
// }

$load_core = $exec_loads[1];


// color theme

$color = $DB->get_record('navbar_color', ['userid' => $USER->id]);
if (!$color->color_mode) {
   $addclass = "fa-toggle-on";
} else {
   $addclass = "";
}


$templatecontext = [
    'sitename' => format_string($SITE->shortname, true, ['context' => context_course::instance(SITEID), "escape" => false]),
    'output' => $OUTPUT,
    'sidepreblocks' => $blockspre,
    'sidepostblocks' => $blockspost,
    'haspreblocks' => $hassidepre,
    'haspostblocks' => $hassidepost,
    'bodyattributes' => $bodyattributes,
    'headercontent' => $headercontent,
    'mylogo' => $CFG->wwwroot,
    'totalstorage' =>formatBytes($total_space),  
    'filledstorage' =>$filled_storage,
    'usage_percent' => $usage_percent,
    'totalmem' => $total_mem,
    'usedmem' => $used_mem,
    'mam_percent' =>$mem_percent,
    'cpu_percent' => $cpu_percent,
    'cpu_total_cores'=> $cpu_total_cores,
    'load_core' => $load_core,
    'addtoggleclass'=>$addclass

];

$data = $DB->get_record('navbar_color',['userid'=>$USER->id]);

// get theme color mode
if ($data) {
  $color = $data->navbar_color;
$color1 = $data->color_mode;
  if ($color) {
    $templatecontext['color'] = $color;
  }
  if ($color1) {
    $templatecontext['color1'] = $color1;
  }
 
}

echo $OUTPUT->render_from_template('theme_classic/columns', $templatecontext);

