<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Global functions for search_elastic plugin.
 *
 * @package    search_elastic
 * @copyright  Matt Porritt <mattp@catalyst-au.net>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Renders the top part of the "new workflow step" modal form. (The part with
 * the "Step type" and "Step" menus.
 *
 * @param array $args
 * @return string
 */
function search_elastic_output_fragment_new_enrich_form($args) {
    $serialiseddata = json_decode($args['jsonformdata']);
    $customdata = [];
    parse_str($serialiseddata, $customdata);
    $url = new moodle_url('/search/engine/elastic/enrich.php');
    $mform = new \search_elastic\enrich_form($url, $customdata, 'post', '', ['class' => 'ignoredirty']);

    ob_start();
    $mform->display();
    $o = ob_get_contents();
    ob_end_clean();

    return $o;
}

/**
 * A hacky way to fix https://tracker.moodle.org/browse/MDL-62537.
 * This code needs to be removed once the tracker properly fixed.
 */
function search_elastic_extend_navigation_user() {
    global $ME;

    if ($ME == '/admin/settings.php?section=searchelastic') {
        redirect(new moodle_url('/search/engine/elastic/index.php'));
    }
}

/**
 * Returns the status checks for this plugin.
 * @return array
 */
function search_elastic_status_checks(): array {
    return [new \search_elastic\check\server_ready_check()];
}
